//**********************************************************************
//
//  Sample Program for Keypad
//
//  Target Machine : CPT-711
//
//  Function:
//  int  getchar(void)  : Get one key stroke from the keyboard buffer.
//  void clr_kb(void)   : To clear the keyboard buffer.
//  void en_alpha(void) : Enable alphabet key stroke processing.
//
//  SYNTECH INFORMATION CO., LTD.
//
//**********************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

void main (void)
    {
    int  x,i;
    unsigned char  ckey;

    clr_scr ();
    gotoxy (3, 1);
    puts ("KEYPAD TEST");

    clr_kb ();
    en_alpha ();
    SetCursor (1);

    x = 0;
    gotoxy (x, 3);
    while (1)
        {
        if (ckey = getchar())
            {
            switch (ckey)
                {
                case KEY_UP:
                     gotoxy (3, 5);
                     puts ("KEY_UP  ");
                     break;

                case KEY_DOWN:
                     gotoxy (3, 5);
                     puts ("KEY_DOWN");
                     break;

                case KEY_BS:
                     gotoxy (3, 5);
                     puts ("KEY_BS  ");
                     break;

                case KEY_CR:
                     gotoxy (3, 5);
                     puts ("KEY_ENT ");
                     break;

                case KEY_ESC:
                     gotoxy (3, 5);
                     puts ("KEY_ESC ");
                     break;

                case ' ':
                     gotoxy (3, 5);
                     puts ("KEY_SP ");
                     break;

                default:
                     gotoxy (x, 3);
                     putchar (ckey);

                     x++;
                     if (x >= 20)
                         {
                         gotoxy (0, 3);
                         puts ("                     ");
                         x = 0;
                         }
                     gotoxy (x, 3);
                     break;
                }
            }
        }
    }
//-------------------------------------------------------------------------//
